(function($) {

    $(document).ready(function() {
        const header = $('.header'),
            usernameBox = header.find('.dashboard_bar'),
            sessionBtn = header.find('#sessionBtn'),
            loginForm = $('#login-form'),
            usernameInput = loginForm.find('input[name="username"]'),
            username = usernameInput.attr('name'),
            isLogged = false;

        // wstawienie nazwy usera, gdy jest zalogowany
        if (isLogged) {
            usernameBox.text(username);
        }

        sessionBtn.addClass('btn-warning');

        sessionBtn.on('click', function(e) {
            e.preventDefault();

            const that = $(this),
                switchText = that.find('span');

            if (!that.hasClass('btn-success')) {
                that.addClass('btn-success');
                that.removeClass('btn-warning');
                switchText.text('Stop');
            } else {
                that.addClass('btn-warning');
                that.removeClass('btn-success');
                switchText.text('Start');
            }
        });

        // funkcja przesyłania formularza
        loginForm.on('submit', function(e) {
            const that = $(this),
                url = that.attr('action'),
                method = that.attr('method');

            let formData = {};

            formData[elemName] = value;

            $.ajax({
                method: method,
                url: url,
                data: formData,
                success: function() {
                    isLogged = true;
                    usernameBox.text(data);
                },
                error: function() {
                    console.log('Error occured!');
                }
            });

            e.preventDefault();
        });

    });
})(jQuery);